"use client"

import { Suspense, useState } from "react"
import { SiteHeader } from "@/components/site-header"
import { PortfolioCard } from "@/components/portfolio-card"
import { Search, ChevronDown } from "lucide-react"
import { Input } from "@/components/ui/input"
import { Button } from "@/components/ui/button"

const projects = [
  {
    id: 1,
    title: "Advanced Robbery System",
    description:
      "A comprehensive illegal activities system featuring dynamic routes, immersive mechanics, and high-risk rewards for FiveM servers.",
    image: "/placeholder.svg?height=400&width=600",
    isNew: true,
    badges: ["FEATURED"],
    statusBadges: [
      { text: "LIVE", color: "green" },
      { text: "OPTIMIZED", color: "primary" },
    ],
    tags: ["QBCORE", "ESX", "QBOX"],
  },
  {
    id: 2,
    title: "House Break-In System",
    description:
      "Realistic house robberies with lockpicking mechanics, alarm systems, and dynamic loot spawns for immersive criminal roleplay.",
    image: "/placeholder.svg?height=400&width=600",
    statusBadges: [
      { text: "COMPLETE", color: "primary" },
      { text: "DOCUMENTED", color: "primary" },
    ],
    tags: ["QBCORE", "ESX"],
  },
  {
    id: 3,
    title: "Train Heist Framework",
    description: "Coordinate crew-based train robberies with NPC guards, valuable cargo, and dynamic chase mechanics.",
    image: "/placeholder.svg?height=400&width=600",
    badges: ["OPEN SOURCE"],
    statusBadges: [{ text: "IN DEVELOPMENT", color: "green" }],
    tags: ["QBCORE", "QBOX"],
  },
  {
    id: 4,
    title: "Police MDT System",
    description:
      "Full-featured mobile data terminal for law enforcement with BOLO alerts, warrant management, and real-time dispatch integration.",
    image: "/placeholder.svg?height=400&width=600",
    badges: ["POPULAR"],
    statusBadges: [
      { text: "LIVE", color: "green" },
      { text: "UPDATED", color: "primary" },
    ],
    tags: ["QBCORE", "ESX", "QBOX"],
  },
  {
    id: 5,
    title: "Vehicle Customization Suite",
    description:
      "Advanced vehicle modification system with custom parts, performance tuning, and visual customization for immersive car culture roleplay.",
    image: "/placeholder.svg?height=400&width=600",
    isNew: true,
    statusBadges: [{ text: "BETA", color: "pink" }],
    tags: ["QBCORE", "ESX"],
  },
  {
    id: 6,
    title: "Dynamic Weather & Time",
    description:
      "Realistic weather patterns and time synchronization system that affects gameplay mechanics and visual atmosphere.",
    image: "/placeholder.svg?height=400&width=600",
    badges: ["OPEN SOURCE"],
    statusBadges: [
      { text: "STABLE", color: "green" },
      { text: "LIGHTWEIGHT", color: "primary" },
    ],
    tags: ["STANDALONE"],
  },
]

function PortfolioContent() {
  const [searchQuery, setSearchQuery] = useState("")
  const [selectedFilter, setSelectedFilter] = useState("All")

  const filteredProjects = projects.filter(
    (project) =>
      project.title.toLowerCase().includes(searchQuery.toLowerCase()) ||
      project.description.toLowerCase().includes(searchQuery.toLowerCase()),
  )

  return (
    <>
      <Suspense fallback={null}>
        <SiteHeader />
      </Suspense>

      <main className="container mx-auto px-6 py-8">
        <div className="flex items-center justify-between mb-8">
          <div>
            <h1 className="text-4xl font-bold mb-2 bg-gradient-to-r from-primary via-cyan-400 to-primary bg-clip-text text-transparent">
              Portfolio
            </h1>
            <p className="text-muted-foreground">Showcasing my FiveM development projects</p>
          </div>

          <div className="flex items-center gap-4">
            <div className="relative w-80">
              <Search className="absolute left-3 top-1/2 -translate-y-1/2 h-4 w-4 text-muted-foreground" />
              <Input
                type="text"
                placeholder="Search projects"
                value={searchQuery}
                onChange={(e) => setSearchQuery(e.target.value)}
                className="pl-10 bg-secondary/50 border-border focus:border-primary"
              />
            </div>

            <Button variant="outline" className="gap-2 bg-secondary/50 border-border hover:border-primary/50">
              {selectedFilter}
              <ChevronDown className="h-4 w-4" />
            </Button>
          </div>
        </div>

        <div className="mb-6 text-sm text-muted-foreground">
          Showing {filteredProjects.length} {filteredProjects.length === 1 ? "project" : "projects"}
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
          {filteredProjects.map((project) => (
            <PortfolioCard key={project.id} {...project} />
          ))}
        </div>

        {filteredProjects.length === 0 && (
          <div className="text-center py-16">
            <p className="text-muted-foreground text-lg">No projects found matching your search.</p>
          </div>
        )}
      </main>
    </>
  )
}

export default function PortfolioPage() {
  return (
    <div className="min-h-screen bg-background text-foreground">
      <PortfolioContent />
    </div>
  )
}
