"use client"

import { Suspense, useState } from "react"
import { SiteHeader } from "@/components/site-header"
import { PortfolioCard } from "@/components/portfolio-card"
import { Search, ChevronDown } from "lucide-react"
import { Input } from "@/components/ui/input"
import { Button } from "@/components/ui/button"

const guides = [
  {
    id: 1,
    title: "Setting Up QBCore Server",
    description:
      "Complete guide to setting up a QBCore FiveM server from scratch with optimization tips and best practices.",
    image: "/placeholder.svg?height=400&width=600",
    isNew: true,
    statusBadges: [
      { text: "UPDATED 2026", color: "green" },
      { text: "BEGINNER", color: "primary" },
    ],
    tags: ["QBCORE", "TUTORIAL", "SETUP"],
  },
  {
    id: 2,
    title: "Advanced Scripting Patterns",
    description:
      "Learn advanced FiveM scripting patterns, optimization techniques, and best practices for resource development.",
    image: "/placeholder.svg?height=400&width=600",
    badges: ["POPULAR"],
    statusBadges: [
      { text: "ADVANCED", color: "pink" },
      { text: "VIDEO GUIDE", color: "primary" },
    ],
    tags: ["LUA", "JAVASCRIPT", "OPTIMIZATION"],
  },
  {
    id: 3,
    title: "Database Management Guide",
    description:
      "Master MySQL database management for FiveM servers including optimization, backups, and security practices.",
    image: "/placeholder.svg?height=400&width=600",
    statusBadges: [{ text: "INTERMEDIATE", color: "primary" }],
    tags: ["MYSQL", "DATABASE", "SECURITY"],
  },
  {
    id: 4,
    title: "Custom UI Development",
    description:
      "Build beautiful custom UIs for FiveM using modern web technologies and frameworks like React and Vue.",
    image: "/placeholder.svg?height=400&width=600",
    badges: ["TRENDING"],
    statusBadges: [{ text: "BEGINNER", color: "primary" }],
    tags: ["UI/UX", "REACT", "HTML/CSS"],
  },
  {
    id: 5,
    title: "Server Performance Tuning",
    description:
      "Optimize your FiveM server performance with advanced configuration, monitoring, and resource management.",
    image: "/placeholder.svg?height=400&width=600",
    statusBadges: [{ text: "EXPERT", color: "red" }],
    tags: ["OPTIMIZATION", "PERFORMANCE", "MONITORING"],
  },
  {
    id: 6,
    title: "Security Best Practices",
    description:
      "Comprehensive security guide covering authentication, anti-cheat, DDoS protection, and server hardening.",
    image: "/placeholder.svg?height=400&width=600",
    isNew: true,
    statusBadges: [{ text: "ESSENTIAL", color: "green" }],
    tags: ["SECURITY", "ANTI-CHEAT", "PROTECTION"],
  },
]

function GuidesContent() {
  const [searchQuery, setSearchQuery] = useState("")

  return (
    <>
      <Suspense fallback={null}>
        <SiteHeader />
      </Suspense>

      <main className="container mx-auto px-6 py-8">
        <div className="flex items-center justify-between mb-8">
          <h1 className="text-3xl font-bold">Guides</h1>

          <div className="flex items-center gap-4">
            <div className="relative w-80">
              <Search className="absolute left-3 top-1/2 -translate-y-1/2 h-4 w-4 text-muted-foreground" />
              <Input
                type="text"
                placeholder="Search guides"
                value={searchQuery}
                onChange={(e) => setSearchQuery(e.target.value)}
                className="pl-10 bg-secondary/50 border-border focus:border-primary"
              />
            </div>

            <Button variant="outline" className="gap-2 bg-secondary/50 border-border hover:border-primary/50">
              All
              <ChevronDown className="h-4 w-4" />
            </Button>
          </div>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
          {guides.map((guide) => (
            <PortfolioCard key={guide.id} {...guide} />
          ))}
        </div>
      </main>
    </>
  )
}

export default function GuidesPage() {
  return (
    <div className="min-h-screen bg-background text-foreground">
      <GuidesContent />
    </div>
  )
}
