"use client"

import { Suspense, useState } from "react"
import { SiteHeader } from "@/components/site-header"
import { Search, Rocket, Download, BookOpen, Code, Wrench, ChevronRight } from "lucide-react"
import { Input } from "@/components/ui/input"
import Link from "next/link"

const sidebarSections = [
  {
    title: "GETTING STARTED",
    items: [
      { name: "Welcome", icon: Rocket, href: "#welcome", active: true },
      { name: "Installation", icon: Download, href: "#installation" },
    ],
  },
  {
    title: "RESOURCES",
    items: [
      { name: "Scripts Documentation", icon: Code, href: "#scripts" },
      { name: "Configuration", icon: Wrench, href: "#configuration" },
      { name: "API Reference", icon: BookOpen, href: "#api" },
    ],
  },
]

function DocsContent() {
  const [searchQuery, setSearchQuery] = useState("")

  return (
    <>
      <Suspense fallback={null}>
        <SiteHeader />
      </Suspense>

      <div className="flex min-h-screen bg-background">
        <aside className="w-80 border-r border-border/50 bg-background/50 backdrop-blur-sm fixed left-0 top-[73px] bottom-0 overflow-y-auto">
          <div className="p-6 space-y-6">
            {/* Search */}
            <div className="relative">
              <Search className="absolute left-3 top-1/2 -translate-y-1/2 h-4 w-4 text-muted-foreground" />
              <Input
                type="text"
                placeholder="Search docs..."
                value={searchQuery}
                onChange={(e) => setSearchQuery(e.target.value)}
                className="pl-10 bg-secondary/30 border-border/50 focus:border-[#b7ff00] rounded-lg"
              />
            </div>

            {/* Navigation Sections */}
            {sidebarSections.map((section) => (
              <div key={section.title} className="space-y-2">
                <h3 className="text-xs font-semibold text-muted-foreground tracking-wider">{section.title}</h3>
                <nav className="space-y-1">
                  {section.items.map((item) => {
                    const Icon = item.icon
                    return (
                      <Link
                        key={item.name}
                        href={item.href}
                        className={`flex items-center gap-3 px-3 py-2 rounded-lg text-sm font-medium transition-all group ${
                          item.active
                            ? "text-black shadow-sm"
                            : "text-muted-foreground hover:text-foreground hover:bg-secondary/30"
                        }`}
                        style={item.active ? { background: "#b7ff00" } : {}}
                      >
                        <Icon className="h-4 w-4" />
                        {item.name}
                        {item.active && <ChevronRight className="h-4 w-4 ml-auto" />}
                      </Link>
                    )
                  })}
                </nav>
              </div>
            ))}
          </div>
        </aside>

        <main className="flex-1 ml-80 pt-[73px]">
          <div className="container mx-auto px-12 py-12 max-w-5xl">
            {/* Breadcrumb */}
            <div className="flex items-center gap-2 text-sm text-muted-foreground mb-8">
              <span>DOCS</span>
              <span>/</span>
              <span style={{ color: "#b7ff00" }}>WELCOME</span>
            </div>

            {/* Welcome Header */}
            <div className="flex items-center gap-3 mb-4">
              <Rocket className="h-8 w-8" style={{ color: "#b7ff00" }} />
              <h1 className="text-5xl font-bold" style={{ color: "#b7ff00" }}>
                WELCOME
              </h1>
            </div>

            <p className="text-xl text-muted-foreground mb-12">
              Official Documentation for Fuze Studios FiveM Resources.
            </p>

            {/* Feature Callout */}
            <div
              className="p-6 rounded-xl mb-12 border-2"
              style={{ borderColor: "#b7ff00", background: "rgba(183, 255, 0, 0.05)" }}
            >
              <p className="text-lg italic leading-relaxed">
                "At Fuze Studios, we are proud to offer a wide selection of high-performance FiveM resources. Our
                official documentation is available to help you get the most out of our collection."
              </p>
            </div>

            {/* Feature Grid */}
            <div className="grid md:grid-cols-2 gap-6 mb-12">
              <div className="p-6 rounded-xl border border-border/50 bg-secondary/20 hover:border-[#b7ff00]/50 transition-colors">
                <div className="flex items-center gap-3 mb-3">
                  <BookOpen className="h-6 w-6" style={{ color: "#b7ff00" }} />
                  <h3 className="text-xl font-semibold">Easy to Understand</h3>
                </div>
                <p className="text-muted-foreground">
                  Our documentation is designed to help you navigate through each of the resources quickly and
                  efficiently.
                </p>
              </div>

              <div className="p-6 rounded-xl border border-border/50 bg-secondary/20 hover:border-[#b7ff00]/50 transition-colors">
                <div className="flex items-center gap-3 mb-3">
                  <Wrench className="h-6 w-6" style={{ color: "#b7ff00" }} />
                  <h3 className="text-xl font-semibold">Always Updated</h3>
                </div>
                <p className="text-muted-foreground">
                  We are constantly updating our docs to ensure you are up-to-date with the latest improvements and
                  features.
                </p>
              </div>
            </div>

            {/* Our Goal Section */}
            <div className="space-y-6">
              <h2 className="text-3xl font-bold">Our Goal</h2>
              <p className="text-muted-foreground leading-relaxed">
                When Fuze Studios first launched in 2018, the market for optimized and well-maintained FiveM resources
                was limited. Our goal from the beginning was to create, optimize, and provide bug-free resources for a
                seamless and high-performance roleplay experience.
              </p>
              <p className="text-muted-foreground leading-relaxed">
                Now in 2025, we continue to expand our collection with innovative scripts and tools, working hard to
                deliver the best quality resources and support to the FiveM community.
              </p>
            </div>
          </div>
        </main>
      </div>
    </>
  )
}

export default function DocsPage() {
  return (
    <div className="min-h-screen bg-background text-foreground">
      <DocsContent />
    </div>
  )
}
